function help4Empty(FUN)
switch(FUN)
    case 'icoshift'
        msg = {'','','    icoshift(target,dataset,alignment mode,max allowed shift,options,scale);'
            'or'
            'icoshift(target,dataset,alignment mode);'
            ''
            'Examples:'
            'icoshift(''median'',xP,20);'
            'splits in 20 regular intervals using the default settings and align them towards the median spectrum'
            'icoshift(''average'',xP,''200'',''40'');'
            'splits in regular intervals made of 200 data points using the default settings'
            'and align them towards the average spectrum allowing a 40 points max shift'
            'icoshift(target,xP,(1000:2000),''b'',[2 1 1]);'
            'aligns the whole spectra according to the reference signal in target(1000:2000)'
            'searching for the best max allowed shift for each interval and performing a pre-coshift step.'
            'Plots the achieved results'
            'icoshift(''average'',xP,user_ints,''f'',[2 0],ppm_scale);'
            'splits the dataset into the intervals defined by the user (user_ints) and aligns them'
            'towards the average spectrum using the highest allowed shift (fastest method) for each interval'
            'and filling the interval edges with NaNs. Plots the achieved results using the ppm_scale provided'
            'For further specifications type ''help icoshift'''};
        
    case 'icoshiftMC'
        msg = {''
            'Use:'
            ''
            '    icoshiftMC(target, dataset, alignment mode, max allowed shift, channels optimality criterion, options, scale, channels);'
            'or'
            '    icoshiftMC(target,dataset);'
            ''
            'Examples:'
            ''
            '  1. icoshiftMC(''median'',xP,20);'
            ''
            '     splits in 20 regular intervals along the second mode, using the default settings (i.e. aligning the sum of all the channels),'
            '     and align each interval towards the median of the same interval in all samples'
            ''
            '  2. icoshiftMC(''average'',xP,''200'',''40'');'
            ''
            '     splits in regular intervals made of 200 consecutive points in the second mode using the default settings'
            '     and align them towards the average of each interval in all samples'
            '     40 points maximum shifts are allowed for every interval'
            ''
            '  3. icoshiftMC(target,xP,(1000:2000),''b'',''sum'',[2 1 1]);'
            ''
            '     aligns the whole samples along the second mode according to the reference region in target(1000:2000);'
            '     the optimal alignment is sought for the sum across all channels and'
            '     so is the best maximum allowed shift for each interval and performing a pre-coshift step.'
            '     Plots the achieved results'
            ''
            '  4. icoshiftMC(''average'',xP,user_ints,''f'',''maxCorr'',[2 0],shiftScale);'
            ''
            '     aligns the intervals defined by the user (user_ints) independently seeking for the shift that maximises the correlation across any one channel;'
            '     the average of all samples is used as a target, and the maximum shift is allowed for each interval (fastest method - corresponding to 50% of the interval''s length).'
            '     The interval edges are filled with NaNs. Plots the achieved results using the ppm_scale provided'
            '     For further specifications type ''help icoshiftMCS'''
            ''};
        
    otherwise, error('Unknonw function')
        
end
fprintf(2,' %s \n',FUN);
fprintf(1,' %s\n',msg{:});